"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, policy_id: str, member_account: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy.    Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been applied to them.   Resources are considered noncompliant for security group policies if they are in scope of the policy, they violate one or more of the policy rules, and remediation is disabled or not possible.   Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the Firewall Manager policy's rules.   Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the rule group associations for the VPC.

    Args:
        policy_id(str): The ID of the policy that you want to get the details for. PolicyId is returned by PutPolicy and by ListPolicies.
        member_account(str): The Amazon Web Services account that owns the resources that you want to get the details for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.compliance.detail.get(
                ctx, policy_id=value, member_account=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.compliance.detail.get policy_id=value, member_account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="get_compliance_detail",
        op_kwargs={"PolicyId": policy_id, "MemberAccount": member_account},
    )
