"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "apps_list"


async def delete(hub, ctx, list_id: str) -> None:
    r"""
    **Autogenerated function**

    Permanently deletes an Firewall Manager applications list.

    Args:
        list_id(str): The ID of the applications list that you want to delete. You can retrieve this ID from PutAppsList, ListAppsLists, and GetAppsList.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.apps_list_.delete(ctx, list_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.apps_list.delete list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="delete_apps_list",
        op_kwargs={"ListId": list_id},
    )


async def get(hub, ctx, list_id: str, default_list: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the specified Firewall Manager applications list.

    Args:
        list_id(str): The ID of the Firewall Manager applications list that you want the details for.
        default_list(bool, optional): Specifies whether the list to retrieve is a default list owned by Firewall Manager. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.apps_list_.get(ctx, list_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.apps_list.get list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="get_apps_list",
        op_kwargs={"ListId": list_id, "DefaultList": default_list},
    )


async def list_all(
    hub, ctx, max_results: int, default_lists: bool = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns an array of AppsListDataSummary objects.

    Args:
        default_lists(bool, optional): Specifies whether the lists to retrieve are default lists owned by Firewall Manager. Defaults to None.
        next_token(str, optional): If you specify a value for MaxResults in your list request, and you have more objects than the maximum, Firewall Manager returns this token in the response. For all but the first request, you provide the token returned by the prior request in the request parameters, to retrieve the next batch of objects. Defaults to None.
        max_results(int): The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a NextToken value that you can use in a subsequent call to get the next batch of objects. If you don't specify this, Firewall Manager returns all available objects.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.apps_list_.list_all(ctx, max_results=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.apps_list.list_all max_results=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="list_apps_lists",
        op_kwargs={
            "DefaultLists": default_lists,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def put(hub, ctx, apps_list: Dict, tag_list: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Firewall Manager applications list.

    Args:
        apps_list(Dict): The details of the Firewall Manager applications list to be created.
        tag_list(List, optional): The tags associated with the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.apps_list_.put(ctx, apps_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.apps_list.put apps_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="put_apps_list",
        op_kwargs={"AppsList": apps_list, "TagList": tag_list},
    )
