"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, admin_account: str) -> None:
    r"""
    **Autogenerated function**

    Sets the Firewall Manager administrator account. The account must be a member of the organization in Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account to administer your Firewall Manager policies. The account that you associate with Firewall Manager is called the Firewall Manager administrator account.

    Args:
        admin_account(str): The Amazon Web Services account ID to associate with Firewall Manager as the Firewall Manager administrator account. This must be an Organizations member account. For more information about Organizations, see Managing the Amazon Web Services Accounts in Your Organization. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.admin_account.associate(ctx, admin_account=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.admin_account.associate admin_account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fms",
        operation="associate_admin_account",
        op_kwargs={"AdminAccount": admin_account},
    )


async def disassociate(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Disassociates the account that has been set as the Firewall Manager administrator account. To set a different account as the administrator account, you must submit an AssociateAdminAccount request.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.admin_account.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.admin_account.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fms", operation="disassociate_admin_account", op_kwargs={}
    )


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fms.admin_account.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fms.admin_account.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fms", operation="get_admin_account", op_kwargs={}
    )
