"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    client_token: str,
    description: str,
    stop_conditions: List,
    actions: Dict,
    role_arn: str,
    targets: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an experiment template.  To create a template, specify the following information:     Targets: A target can be a specific resource in your AWS environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.    Actions: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.    Stop conditions: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.   For more information, see the AWS Fault Injection Simulator User Guide.

    Args:
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        description(str): A description for the experiment template. Can contain up to 64 letters (A-Z and a-z).
        stop_conditions(List): The stop conditions.
        targets(Dict, optional): The targets for the experiment. Defaults to None.
        actions(Dict): The actions for the experiment.
        role_arn(str): The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
        tags(Dict, optional): The tags to apply to the experiment template. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.template.create(
                ctx,
                client_token=value,
                description=value,
                stop_conditions=value,
                actions=value,
                role_arn=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.template.create client_token=value, description=value, stop_conditions=value, actions=value, role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="create_experiment_template",
        op_kwargs={
            "clientToken": client_token,
            "description": description,
            "stopConditions": stop_conditions,
            "targets": targets,
            "actions": actions,
            "roleArn": role_arn,
            "tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified experiment template.

    Args:
        id_(str): The ID of the experiment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.template.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.template.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="delete_experiment_template",
        op_kwargs={"id": id_},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified experiment template.

    Args:
        id_(str): The ID of the experiment template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.template.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.template.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="get_experiment_template",
        op_kwargs={"id": id_},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists your experiment templates.

    Args:
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.template.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.template.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="list_experiment_templates",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def update(
    hub,
    ctx,
    id_: str,
    description: str = None,
    stop_conditions: List = None,
    targets: Dict = None,
    actions: Dict = None,
    role_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified experiment template.

    Args:
        id_(str): The ID of the experiment template.
        description(str, optional): A description for the template. Defaults to None.
        stop_conditions(List, optional): The stop conditions for the experiment. Defaults to None.
        targets(Dict, optional): The targets for the experiment. Defaults to None.
        actions(Dict, optional): The actions for the experiment. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.template.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.template.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="update_experiment_template",
        op_kwargs={
            "id": id_,
            "description": description,
            "stopConditions": stop_conditions,
            "targets": targets,
            "actions": actions,
            "roleArn": role_arn,
        },
    )
