"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified experiment.

    Args:
        id_(str): The ID of the experiment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fis", operation="get_experiment", op_kwargs={"id": id_}
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists your experiments.

    Args:
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="list_experiments",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )


async def start(
    hub, ctx, client_token: str, experiment_template_id: str, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Starts running an experiment from the specified experiment template.

    Args:
        client_token(str): Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
        experiment_template_id(str): The ID of the experiment template.
        tags(Dict, optional): The tags to apply to the experiment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.init.start(
                ctx, client_token=value, experiment_template_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.init.start client_token=value, experiment_template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="start_experiment",
        op_kwargs={
            "clientToken": client_token,
            "experimentTemplateId": experiment_template_id,
            "tags": tags,
        },
    )


async def stop(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the specified experiment.

    Args:
        id_(str): The ID of the experiment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.experiment.init.stop(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.experiment.init.stop id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fis", operation="stop_experiment", op_kwargs={"id": id_}
    )
