"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified AWS FIS action.

    Args:
        id_(str): The ID of the action.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.action.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.action.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="fis", operation="get_action", op_kwargs={"id": id_}
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the available AWS FIS actions.

    Args:
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.fis.action.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.fis.action.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="fis",
        operation="list_actions",
        op_kwargs={"maxResults": max_results, "nextToken": next_token},
    )
