"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    delivery_stream_name: str,
    exclusive_start_tag_key: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags for the specified delivery stream. This operation has a limit of five transactions per second per account.

    Args:
        delivery_stream_name(str): The name of the delivery stream whose tags you want to list.
        exclusive_start_tag_key(str, optional): The key to use as the starting point for the list of tags. If you set this parameter, ListTagsForDeliveryStream gets all tags that occur after ExclusiveStartTagKey. Defaults to None.
        limit(int, optional): The number of tags to return. If this number is less than the total number of tags associated with the delivery stream, HasMoreTags is set to true in the response. To list additional tags, set ExclusiveStartTagKey to the last key in the response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.tags_for_delivery_stream.list(
                ctx, delivery_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.tags_for_delivery_stream.list delivery_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="list_tags_for_delivery_stream",
        op_kwargs={
            "DeliveryStreamName": delivery_stream_name,
            "ExclusiveStartTagKey": exclusive_start_tag_key,
            "Limit": limit,
        },
    )
