"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    delivery_stream_name: str,
    current_delivery_stream_version_id: str,
    destination_id: str,
    s3_destination_update: Dict = None,
    extended_s3_destination_update: Dict = None,
    redshift_destination_update: Dict = None,
    elasticsearch_destination_update: Dict = None,
    splunk_destination_update: Dict = None,
    http_endpoint_destination_update: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified destination of the specified delivery stream. Use this operation to change the destination type (for example, to replace the Amazon S3 destination with Amazon Redshift) or change the parameters associated with a destination (for example, to change the bucket name of the Amazon S3 destination). The update might not occur immediately. The target delivery stream remains active while the configurations are updated, so data writes to the delivery stream can continue during this process. The updated configurations are usually effective within a few minutes. Switching between Amazon ES and other services is not supported. For an Amazon ES destination, you can only update to another Amazon ES destination. If the destination type is the same, Kinesis Data Firehose merges the configuration parameters specified with the destination configuration that already exists on the delivery stream. If any of the parameters are not specified in the call, the existing values are retained. For example, in the Amazon S3 destination, if EncryptionConfiguration is not specified, then the existing EncryptionConfiguration is maintained on the destination. If the destination type is not the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Kinesis Data Firehose does not merge any parameters. In this case, all parameters must be specified. Kinesis Data Firehose uses CurrentDeliveryStreamVersionId to avoid race conditions and conflicting merges. This is a required field, and the service updates the configuration only if the existing configuration has a version ID that matches. After the update is applied successfully, the version ID is updated, and can be retrieved using DescribeDeliveryStream. Use the new version ID to set CurrentDeliveryStreamVersionId in the next call.

    Args:
        delivery_stream_name(str): The name of the delivery stream.
        current_delivery_stream_version_id(str): Obtain this value from the VersionId result of DeliveryStreamDescription. This value is required, and helps the service perform conditional operations. For example, if there is an interleaving update and this value is null, then the update destination fails. After the update is successful, the VersionId value is updated. The service then performs a merge of the old configuration with the new configuration.
        destination_id(str): The ID of the destination.
        s3_destination_update(Dict, optional): [Deprecated] Describes an update for a destination in Amazon S3. Defaults to None.
        extended_s3_destination_update(Dict, optional): Describes an update for a destination in Amazon S3. Defaults to None.
        redshift_destination_update(Dict, optional): Describes an update for a destination in Amazon Redshift. Defaults to None.
        elasticsearch_destination_update(Dict, optional): Describes an update for a destination in Amazon ES. Defaults to None.
        splunk_destination_update(Dict, optional): Describes an update for a destination in Splunk. Defaults to None.
        http_endpoint_destination_update(Dict, optional): Describes an update to the specified HTTP endpoint destination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.destination.update(
                ctx,
                delivery_stream_name=value,
                current_delivery_stream_version_id=value,
                destination_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.destination.update delivery_stream_name=value, current_delivery_stream_version_id=value, destination_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="update_destination",
        op_kwargs={
            "DeliveryStreamName": delivery_stream_name,
            "CurrentDeliveryStreamVersionId": current_delivery_stream_version_id,
            "DestinationId": destination_id,
            "S3DestinationUpdate": s3_destination_update,
            "ExtendedS3DestinationUpdate": extended_s3_destination_update,
            "RedshiftDestinationUpdate": redshift_destination_update,
            "ElasticsearchDestinationUpdate": elasticsearch_destination_update,
            "SplunkDestinationUpdate": splunk_destination_update,
            "HttpEndpointDestinationUpdate": http_endpoint_destination_update,
        },
    )
