"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    delivery_stream_name: str,
    delivery_stream_type: str = None,
    kinesis_stream_source_configuration: Dict = None,
    delivery_stream_encryption_configuration_input: Dict = None,
    s3_destination_configuration: Dict = None,
    extended_s3_destination_configuration: Dict = None,
    redshift_destination_configuration: Dict = None,
    elasticsearch_destination_configuration: Dict = None,
    splunk_destination_configuration: Dict = None,
    http_endpoint_destination_configuration: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Kinesis Data Firehose delivery stream. By default, you can create up to 50 delivery streams per AWS Region. This is an asynchronous operation that immediately returns. The initial status of the delivery stream is CREATING. After the delivery stream is created, its status is ACTIVE and it now accepts data. If the delivery stream creation fails, the status transitions to CREATING_FAILED. Attempts to send data to a delivery stream that is not in the ACTIVE state cause an exception. To check the state of a delivery stream, use DescribeDeliveryStream. If the status of a delivery stream is CREATING_FAILED, this status doesn't change, and you can't invoke CreateDeliveryStream again on it. However, you can invoke the DeleteDeliveryStream operation to delete it. A Kinesis Data Firehose delivery stream can be configured to receive records directly from providers using PutRecord or PutRecordBatch, or it can be configured to use an existing Kinesis stream as its source. To specify a Kinesis data stream as input, set the DeliveryStreamType parameter to KinesisStreamAsSource, and provide the Kinesis stream Amazon Resource Name (ARN) and role ARN in the KinesisStreamSourceConfiguration parameter. To create a delivery stream with server-side encryption (SSE) enabled, include DeliveryStreamEncryptionConfigurationInput in your request. This is optional. You can also invoke StartDeliveryStreamEncryption to turn on SSE for an existing delivery stream that doesn't have SSE enabled. A delivery stream is configured with a single destination: Amazon S3, Amazon ES, Amazon Redshift, or Splunk. You must specify only one of the following destination configuration parameters: ExtendedS3DestinationConfiguration, S3DestinationConfiguration, ElasticsearchDestinationConfiguration, RedshiftDestinationConfiguration, or SplunkDestinationConfiguration. When you specify S3DestinationConfiguration, you can also provide the following optional values: BufferingHints, EncryptionConfiguration, and CompressionFormat. By default, if no BufferingHints value is provided, Kinesis Data Firehose buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied first. BufferingHints is a hint, so there are some cases where the service cannot adhere to these conditions strictly. For example, record boundaries might be such that the size is a little over or under the configured buffering size. By default, no encryption is performed. We strongly recommend that you enable encryption to ensure secure data storage in Amazon S3. A few notes about Amazon Redshift as a destination:   An Amazon Redshift destination requires an S3 bucket as intermediate location. Kinesis Data Firehose first delivers data to Amazon S3 and then uses COPY syntax to load data into an Amazon Redshift table. This is specified in the RedshiftDestinationConfiguration.S3Configuration parameter.   The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration because the Amazon Redshift COPY operation that reads from the S3 bucket doesn't support these compression formats.   We strongly recommend that you use the user name and password you provide exclusively with Kinesis Data Firehose, and that the permissions for the account are restricted for Amazon Redshift INSERT permissions.   Kinesis Data Firehose assumes the IAM role that is configured as part of the destination. The role should allow the Kinesis Data Firehose principal to assume the role, and the role should have permissions that allow the service to deliver the data. For more information, see Grant Kinesis Data Firehose Access to an Amazon S3 Destination in the Amazon Kinesis Data Firehose Developer Guide.

    Args:
        delivery_stream_name(str): The name of the delivery stream. This name must be unique per AWS account in the same AWS Region. If the delivery streams are in different accounts or different Regions, you can have multiple delivery streams with the same name.
        delivery_stream_type(str, optional): The delivery stream type. This parameter can be one of the following values:    DirectPut: Provider applications access the delivery stream directly.    KinesisStreamAsSource: The delivery stream uses a Kinesis data stream as a source.  . Defaults to None.
        kinesis_stream_source_configuration(Dict, optional): When a Kinesis data stream is used as the source for the delivery stream, a KinesisStreamSourceConfiguration containing the Kinesis data stream Amazon Resource Name (ARN) and the role ARN for the source stream. Defaults to None.
        delivery_stream_encryption_configuration_input(Dict, optional): Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE). Defaults to None.
        s3_destination_configuration(Dict, optional): [Deprecated] The destination in Amazon S3. You can specify only one destination. Defaults to None.
        extended_s3_destination_configuration(Dict, optional): The destination in Amazon S3. You can specify only one destination. Defaults to None.
        redshift_destination_configuration(Dict, optional): The destination in Amazon Redshift. You can specify only one destination. Defaults to None.
        elasticsearch_destination_configuration(Dict, optional): The destination in Amazon ES. You can specify only one destination. Defaults to None.
        splunk_destination_configuration(Dict, optional): The destination in Splunk. You can specify only one destination. Defaults to None.
        http_endpoint_destination_configuration(Dict, optional): Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination. You can specify only one destination. Defaults to None.
        tags(List, optional): A set of tags to assign to the delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide. You can specify up to 50 tags when creating a delivery stream. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.delivery_stream.init.create(
                ctx, delivery_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.delivery_stream.init.create delivery_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="create_delivery_stream",
        op_kwargs={
            "DeliveryStreamName": delivery_stream_name,
            "DeliveryStreamType": delivery_stream_type,
            "KinesisStreamSourceConfiguration": kinesis_stream_source_configuration,
            "DeliveryStreamEncryptionConfigurationInput": delivery_stream_encryption_configuration_input,
            "S3DestinationConfiguration": s3_destination_configuration,
            "ExtendedS3DestinationConfiguration": extended_s3_destination_configuration,
            "RedshiftDestinationConfiguration": redshift_destination_configuration,
            "ElasticsearchDestinationConfiguration": elasticsearch_destination_configuration,
            "SplunkDestinationConfiguration": splunk_destination_configuration,
            "HttpEndpointDestinationConfiguration": http_endpoint_destination_configuration,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, delivery_stream_name: str, allow_force_delete: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a delivery stream and its data. To check the state of a delivery stream, use DescribeDeliveryStream. You can delete a delivery stream only if it is in one of the following states: ACTIVE, DELETING, CREATING_FAILED, or DELETING_FAILED. You can't delete a delivery stream that is in the CREATING state. While the deletion request is in process, the delivery stream is in the DELETING state. While the delivery stream is in the DELETING state, the service might continue to accept records, but it doesn't make any guarantees with respect to delivering the data. Therefore, as a best practice, first stop any applications that are sending records before you delete a delivery stream.

    Args:
        delivery_stream_name(str): The name of the delivery stream.
        allow_force_delete(bool, optional): Set this to true if you want to delete the delivery stream even if Kinesis Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose might be unable to retire the grant due to a customer error, such as when the CMK or the grant are in an invalid state. If you force deletion, you can then use the RevokeGrant operation to revoke the grant you gave to Kinesis Data Firehose. If a failure to retire the grant happens due to an AWS KMS issue, Kinesis Data Firehose keeps retrying the delete operation. The default value is false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.delivery_stream.init.delete(
                ctx, delivery_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.delivery_stream.init.delete delivery_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="delete_delivery_stream",
        op_kwargs={
            "DeliveryStreamName": delivery_stream_name,
            "AllowForceDelete": allow_force_delete,
        },
    )


async def describe(
    hub,
    ctx,
    delivery_stream_name: str,
    limit: int = None,
    exclusive_start_destination_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified delivery stream and its status. For example, after your delivery stream is created, call DescribeDeliveryStream to see whether the delivery stream is ACTIVE and therefore ready for data to be sent to it.  If the status of a delivery stream is CREATING_FAILED, this status doesn't change, and you can't invoke CreateDeliveryStream again on it. However, you can invoke the DeleteDeliveryStream operation to delete it. If the status is DELETING_FAILED, you can force deletion by invoking DeleteDeliveryStream again but with DeleteDeliveryStreamInput$AllowForceDelete set to true.

    Args:
        delivery_stream_name(str): The name of the delivery stream.
        limit(int, optional): The limit on the number of destinations to return. You can have one destination per delivery stream. Defaults to None.
        exclusive_start_destination_id(str, optional): The ID of the destination to start returning the destination information. Kinesis Data Firehose supports one destination per delivery stream. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.delivery_stream.init.describe(
                ctx, delivery_stream_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.delivery_stream.init.describe delivery_stream_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="describe_delivery_stream",
        op_kwargs={
            "DeliveryStreamName": delivery_stream_name,
            "Limit": limit,
            "ExclusiveStartDestinationId": exclusive_start_destination_id,
        },
    )


async def list_all(
    hub,
    ctx,
    limit: int = None,
    delivery_stream_type: str = None,
    exclusive_start_delivery_stream_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your delivery streams in alphabetical order of their names. The number of delivery streams might be too large to return using a single call to ListDeliveryStreams. You can limit the number of delivery streams returned, using the Limit parameter. To determine whether there are more delivery streams to list, check the value of HasMoreDeliveryStreams in the output. If there are more delivery streams to list, you can request them by calling this operation again and setting the ExclusiveStartDeliveryStreamName parameter to the name of the last delivery stream returned in the last call.

    Args:
        limit(int, optional): The maximum number of delivery streams to list. The default value is 10. Defaults to None.
        delivery_stream_type(str, optional): The delivery stream type. This can be one of the following values:    DirectPut: Provider applications access the delivery stream directly.    KinesisStreamAsSource: The delivery stream uses a Kinesis data stream as a source.   This parameter is optional. If this parameter is omitted, delivery streams of all types are returned. Defaults to None.
        exclusive_start_delivery_stream_name(str, optional): The list of delivery streams returned by this call to ListDeliveryStreams will start with the delivery stream whose name comes alphabetically immediately after the name you specify in ExclusiveStartDeliveryStreamName. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.delivery_stream.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.delivery_stream.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="list_delivery_streams",
        op_kwargs={
            "Limit": limit,
            "DeliveryStreamType": delivery_stream_type,
            "ExclusiveStartDeliveryStreamName": exclusive_start_delivery_stream_name,
        },
    )


async def tag(hub, ctx, delivery_stream_name: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or updates tags for the specified delivery stream. A tag is a key-value pair that you can define and assign to AWS resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide.  Each delivery stream can have up to 50 tags.  This operation has a limit of five transactions per second per account.

    Args:
        delivery_stream_name(str): The name of the delivery stream to which you want to add the tags.
        tags(List): A set of key-value pairs to use to create the tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.delivery_stream.init.tag(
                ctx, delivery_stream_name=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.delivery_stream.init.tag delivery_stream_name=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="tag_delivery_stream",
        op_kwargs={"DeliveryStreamName": delivery_stream_name, "Tags": tags},
    )


async def untag(hub, ctx, delivery_stream_name: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from the specified delivery stream. Removed tags are deleted, and you can't recover them after this operation successfully completes. If you specify a tag that doesn't exist, the operation ignores it. This operation has a limit of five transactions per second per account.

    Args:
        delivery_stream_name(str): The name of the delivery stream.
        tag_keys(List): A list of tag keys. Each corresponding tag is removed from the delivery stream.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.firehose.delivery_stream.init.untag(
                ctx, delivery_stream_name=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.firehose.delivery_stream.init.untag delivery_stream_name=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="firehose",
        operation="untag_delivery_stream",
        op_kwargs={"DeliveryStreamName": delivery_stream_name, "TagKeys": tag_keys},
    )
