"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, location_type: str = None) -> Dict:
    r"""
    **Autogenerated function**

    A temporary Amazon S3 location to copy your files from a source location to stage or use as a scratch space in Habanero notebook.

    Args:
        location_type(str, optional): Specify the type of the working location.    SAGEMAKER - Use the Amazon S3 location as a temporary location to store data content when working with FinSpace Notebooks that run on SageMaker studio.    INGESTION - Use the Amazon S3 location as a staging location to copy your data content and then use the location with the changeset creation operation.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace_data.working_location.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace_data.working_location.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace-data",
        operation="get_working_location",
        op_kwargs={"locationType": location_type},
    )
