"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, environment_id: str, duration_in_minutes: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Request programmatic credentials to use with Habanero SDK.

    Args:
        duration_in_minutes(int, optional): The time duration in which the credentials remain valid. . Defaults to None.
        environment_id(str): The habanero environment identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace_data.programmatic_access_credential.get_all(
                ctx, environment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace_data.programmatic_access_credential.get_all environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace-data",
        operation="get_programmatic_access_credentials",
        op_kwargs={
            "durationInMinutes": duration_in_minutes,
            "environmentId": environment_id,
        },
    )
