"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    dataset_id: str,
    change_type: str,
    source_type: str,
    source_params: Dict,
    format_type: str = None,
    format_params: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new changeset in a FinSpace dataset.

    Args:
        dataset_id(str): The unique identifier for the FinSpace dataset in which the changeset will be created.
        change_type(str): Option to indicate how a changeset will be applied to a dataset.    REPLACE - Changeset will be considered as a replacement to all prior loaded changesets.    APPEND - Changeset will be considered as an addition to the end of all prior loaded changesets.  .
        source_type(str): Type of the data source from which the files to create the changeset will be sourced.    S3 - Amazon S3.  .
        source_params(Dict): Source path from which the files to create the changeset will be sourced.
        format_type(str, optional): Format type of the input files being loaded into the changeset. Defaults to None.
        format_params(Dict, optional): Options that define the structure of the source file(s). Defaults to None.
        tags(Dict, optional): Metadata tags to apply to this changeset. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace_data.changeset.create(
                ctx, dataset_id=value, change_type=value, source_type=value, source_params=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace_data.changeset.create dataset_id=value, change_type=value, source_type=value, source_params=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace-data",
        operation="create_changeset",
        op_kwargs={
            "datasetId": dataset_id,
            "changeType": change_type,
            "sourceType": source_type,
            "sourceParams": source_params,
            "formatType": format_type,
            "formatParams": format_params,
            "tags": tags,
        },
    )
