"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    kms_key_id: str = None,
    tags: Dict = None,
    federation_mode: str = None,
    federation_parameters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create a new FinSpace environment.

    Args:
        name(str): The name of the FinSpace environment to be created.
        description(str, optional): The description of the FinSpace environment to be created. Defaults to None.
        kms_key_id(str, optional): The KMS key id to encrypt your data in the FinSpace environment. Defaults to None.
        tags(Dict, optional): Add tags to your FinSpace environment. Defaults to None.
        federation_mode(str, optional): Authentication mode for the environment.    FEDERATED - Users access FinSpace through Single Sign On (SSO) via your Identity provider.    LOCAL - Users access FinSpace via email and password managed within the FinSpace environment.  . Defaults to None.
        federation_parameters(Dict, optional): Configuration information when authentication mode is FEDERATED. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace.environment.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace.environment.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace",
        operation="create_environment",
        op_kwargs={
            "name": name,
            "description": description,
            "kmsKeyId": kms_key_id,
            "tags": tags,
            "federationMode": federation_mode,
            "federationParameters": federation_parameters,
        },
    )


async def delete(hub, ctx, environment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete an FinSpace environment.

    Args:
        environment_id(str): The identifier for the FinSpace environment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace.environment.delete(ctx, environment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace.environment.delete environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace",
        operation="delete_environment",
        op_kwargs={"environmentId": environment_id},
    )


async def get(hub, ctx, environment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the FinSpace environment object.

    Args:
        environment_id(str): The identifier of the FinSpace environment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace.environment.get(ctx, environment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace.environment.get environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace",
        operation="get_environment",
        op_kwargs={"environmentId": environment_id},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    A list of all of your FinSpace environments.

    Args:
        next_token(str, optional): A token generated by FinSpace that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the nextToken value from the response object of the previous page call. Defaults to None.
        max_results(int, optional): The maximum number of results to return in this request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace.environment.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace.environment.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace",
        operation="list_environments",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    environment_id: str,
    name: str = None,
    description: str = None,
    federation_mode: str = None,
    federation_parameters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update your FinSpace environment.

    Args:
        environment_id(str): The identifier of the FinSpace environment.
        name(str, optional): The name of the environment. Defaults to None.
        description(str, optional): The description of the environment. Defaults to None.
        federation_mode(str, optional): Authentication mode for the environment.    FEDERATED - Users access FinSpace through Single Sign On (SSO) via your Identity provider.    LOCAL - Users access FinSpace via email and password managed within the FinSpace environment.  . Defaults to None.
        federation_parameters(Dict, optional): Configuration information when authentication mode is FEDERATED. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.finspace.environment.update(ctx, environment_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.finspace.environment.update environment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="finspace",
        operation="update_environment",
        op_kwargs={
            "environmentId": environment_id,
            "name": name,
            "description": description,
            "federationMode": federation_mode,
            "federationParameters": federation_parameters,
        },
    )
