"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    rule: str,
    event_bus_name: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the targets assigned to the specified rule.

    Args:
        rule(str): The name of the rule.
        event_bus_name(str, optional): The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.target.by_rule.list(ctx, rule=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.target.by_rule.list rule=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_targets_by_rule",
        op_kwargs={
            "Rule": rule,
            "EventBusName": event_bus_name,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
