"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, name: str, event_bus_name: str = None, force: bool = None
) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified rule. Before you can delete the rule, you must remove all targets, using RemoveTargets. When you delete a rule, incoming events might continue to match to the deleted rule. Allow a short period of time for changes to take effect. If you call delete rule multiple times for the same rule, all calls will succeed. When you call delete rule for a non-existent custom eventbus, ResourceNotFoundException is returned. Managed rules are rules created and managed by another AWS service on your behalf. These rules are created by those other AWS services to support functionality in those services. You can delete these rules using the Force option, but you should do so only if you are sure the other service is not still using that rule.

    Args:
        name(str): The name of the rule.
        event_bus_name(str, optional): The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used. Defaults to None.
        force(bool, optional): If this is a managed rule, created by an AWS service on your behalf, you must specify Force as True to delete the rule. This parameter is ignored for rules that are not managed rules. You can check whether a rule is a managed rule by using DescribeRule or ListRules and checking the ManagedBy field of the response. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.rule.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.rule.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="delete_rule",
        op_kwargs={"Name": name, "EventBusName": event_bus_name, "Force": force},
    )


async def describe(hub, ctx, name: str, event_bus_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the specified rule. DescribeRule does not list the targets of a rule. To see the targets associated with a rule, use ListTargetsByRule.

    Args:
        name(str): The name of the rule.
        event_bus_name(str, optional): The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.rule.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.rule.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_rule",
        op_kwargs={"Name": name, "EventBusName": event_bus_name},
    )


async def disable(hub, ctx, name: str, event_bus_name: str = None) -> None:
    r"""
    **Autogenerated function**

    Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression. When you disable a rule, incoming events might continue to match to the disabled rule. Allow a short period of time for changes to take effect.

    Args:
        name(str): The name of the rule.
        event_bus_name(str, optional): The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.rule.init.disable(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.rule.init.disable name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="disable_rule",
        op_kwargs={"Name": name, "EventBusName": event_bus_name},
    )


async def enable(hub, ctx, name: str, event_bus_name: str = None) -> None:
    r"""
    **Autogenerated function**

    Enables the specified rule. If the rule does not exist, the operation fails. When you enable a rule, incoming events might not immediately start matching to a newly enabled rule. Allow a short period of time for changes to take effect.

    Args:
        name(str): The name of the rule.
        event_bus_name(str, optional): The name or ARN of the event bus associated with the rule. If you omit this, the default event bus is used. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.rule.init.enable(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.rule.init.enable name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="enable_rule",
        op_kwargs={"Name": name, "EventBusName": event_bus_name},
    )


async def list_all(
    hub,
    ctx,
    name_prefix: str = None,
    event_bus_name: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names. ListRules does not list the targets of a rule. To see the targets associated with a rule, use ListTargetsByRule.

    Args:
        name_prefix(str, optional): The prefix matching the rule name. Defaults to None.
        event_bus_name(str, optional): The name or ARN of the event bus to list the rules for. If you omit this, the default event bus is used. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.rule.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.rule.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_rules",
        op_kwargs={
            "NamePrefix": name_prefix,
            "EventBusName": event_bus_name,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def put(
    hub,
    ctx,
    name: str,
    schedule_expression: str = None,
    event_pattern: str = None,
    state: str = None,
    description: str = None,
    role_arn: str = None,
    tags: List = None,
    event_bus_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using DisableRule. A single rule watches for events from a single event bus. Events generated by AWS services go to your account's default event bus. Events generated by SaaS partner services or applications go to the matching partner event bus. If you have custom applications or services, you can specify whether their events go to your default event bus or a custom event bus that you have created. For more information, see CreateEventBus. If you are updating an existing rule, the rule is replaced with what you specify in this PutRule command. If you omit arguments in PutRule, the old values for those arguments are not kept. Instead, they are replaced with null values. When you create or update a rule, incoming events might not immediately start matching to new or updated rules. Allow a short period of time for changes to take effect. A rule must contain at least an EventPattern or ScheduleExpression. Rules with EventPatterns are triggered when a matching event is observed. Rules with ScheduleExpressions self-trigger based on the given schedule. A rule can have both an EventPattern and a ScheduleExpression, in which case the rule triggers on matching events as well as on a schedule. When you initially create a rule, you can optionally assign one or more tags to the rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only rules with certain tag values. To use the PutRule operation and assign tags, you must have both the events:PutRule and events:TagResource permissions. If you are updating an existing rule, any tags you specify in the PutRule operation are ignored. To update the tags of an existing rule, use TagResource and UntagResource. Most services in AWS treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match. In EventBridge, it is possible to create rules that lead to infinite loops, where a rule is fired repeatedly. For example, a rule might detect that ACLs have changed on an S3 bucket, and trigger software to change them to the desired state. If the rule is not written carefully, the subsequent change to the ACLs fires the rule again, creating an infinite loop. To prevent this, write the rules so that the triggered actions do not re-fire the same rule. For example, your rule could fire only if ACLs are found to be in a bad state, instead of after any change.  An infinite loop can quickly cause higher than expected charges. We recommend that you use budgeting, which alerts you when charges exceed your specified limit. For more information, see Managing Your Costs with Budgets.

    Args:
        name(str): The name of the rule that you are creating or updating.
        schedule_expression(str, optional): The scheduling expression. For example, "cron(0 20 * * ? *)" or "rate(5 minutes)". Defaults to None.
        event_pattern(str, optional): The event pattern. For more information, see Events and Event Patterns in the Amazon EventBridge User Guide. Defaults to None.
        state(str, optional): Indicates whether the rule is enabled or disabled. Defaults to None.
        description(str, optional): A description of the rule. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role associated with the rule. Defaults to None.
        tags(List, optional): The list of key-value pairs to associate with the rule. Defaults to None.
        event_bus_name(str, optional): The name or ARN of the event bus to associate with this rule. If you omit this, the default event bus is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.rule.init.put(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.rule.init.put name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="put_rule",
        op_kwargs={
            "Name": name,
            "ScheduleExpression": schedule_expression,
            "EventPattern": event_pattern,
            "State": state,
            "Description": description,
            "RoleArn": role_arn,
            "Tags": tags,
            "EventBusName": event_bus_name,
        },
    )
