"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, replay_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels the specified replay.

    Args:
        replay_name(str): The name of the replay to cancel.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.replay.cancel(ctx, replay_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.replay.cancel replay_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="cancel_replay",
        op_kwargs={"ReplayName": replay_name},
    )


async def describe(hub, ctx, replay_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details about a replay. Use DescribeReplay to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use StartReplay and specify an EventStartTime and an EventEndTime that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use DescribeReplay to determine the progress of a replay. The value returned for EventLastReplayedTime indicates the time within the specified time range associated with the last event replayed.

    Args:
        replay_name(str): The name of the replay to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.replay.describe(ctx, replay_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.replay.describe replay_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_replay",
        op_kwargs={"ReplayName": replay_name},
    )


async def list_all(
    hub,
    ctx,
    name_prefix: str = None,
    state: str = None,
    event_source_arn: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.

    Args:
        name_prefix(str, optional): A name prefix to filter the replays returned. Only replays with name that match the prefix are returned. Defaults to None.
        state(str, optional): The state of the replay. Defaults to None.
        event_source_arn(str, optional): The ARN of the event source associated with the replay. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): The maximum number of replays to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.replay.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.replay.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_replays",
        op_kwargs={
            "NamePrefix": name_prefix,
            "State": state,
            "EventSourceArn": event_source_arn,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def start(
    hub,
    ctx,
    replay_name: str,
    event_source_arn: str,
    event_start_time: str,
    event_end_time: str,
    destination: Dict,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an EventStartTime and an EventEndTime that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use DescribeReplay to determine the progress of a replay. The value returned for EventLastReplayedTime indicates the time within the specified time range associated with the last event replayed.

    Args:
        replay_name(str): The name of the replay to start.
        description(str, optional): A description for the replay to start. Defaults to None.
        event_source_arn(str): The ARN of the archive to replay events from.
        event_start_time(str): A time stamp for the time to start replaying events. Only events that occurred between the EventStartTime and EventEndTime are replayed.
        event_end_time(str): A time stamp for the time to stop replaying events. Only events that occurred between the EventStartTime and EventEndTime are replayed.
        destination(Dict): A ReplayDestination object that includes details about the destination for the replay.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.replay.start(
                ctx,
                replay_name=value,
                event_source_arn=value,
                event_start_time=value,
                event_end_time=value,
                destination=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.replay.start replay_name=value, event_source_arn=value, event_start_time=value, event_end_time=value, destination=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="start_replay",
        op_kwargs={
            "ReplayName": replay_name,
            "Description": description,
            "EventSourceArn": event_source_arn,
            "EventStartTime": event_start_time,
            "EventEndTime": event_end_time,
            "Destination": destination,
        },
    )
