"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub,
    ctx,
    event_bus_name: str = None,
    action: str = None,
    principal: str = None,
    statement_id: str = None,
    condition: Dict = None,
    policy: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Running PutPermission permits the specified AWS account or AWS organization to put events to the specified event bus. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account.  For another account to send events to your account, that external account must have an EventBridge rule with your account's event bus as a target. To enable multiple AWS accounts to put events to your event bus, run PutPermission once for each of these accounts. Or, if all the accounts are members of the same AWS organization, you can run PutPermission once specifying Principal as "*" and specifying the AWS organization ID in Condition, to grant permissions to all accounts in that organization. If you grant permissions using an organization, then accounts in that organization must specify a RoleArn with proper permissions when they use PutTarget to add your account's event bus as a target. For more information, see Sending and Receiving Events Between AWS Accounts in the Amazon EventBridge User Guide. The permission policy on the default event bus cannot exceed 10 KB in size.

    Args:
        event_bus_name(str, optional): The name of the event bus associated with the rule. If you omit this, the default event bus is used. Defaults to None.
        action(str, optional): The action that you are enabling the other account to perform. Currently, this must be events:PutEvents. Defaults to None.
        principal(str, optional): The 12-digit AWS account ID that you are permitting to put events to your default event bus. Specify "*" to permit any account to put events to your default event bus. If you specify "*" without specifying Condition, avoid creating rules that may match undesirable events. To create more secure rules, make sure that the event pattern for each rule contains an account field with a specific account ID from which to receive events. Rules with an account field do not match any events sent from other accounts. Defaults to None.
        statement_id(str, optional): An identifier string for the external account that you are granting permissions to. If you later want to revoke the permission for this external account, specify this StatementId when you run RemovePermission. Defaults to None.
        condition(Dict, optional): This parameter enables you to limit the permission to accounts that fulfill a certain condition, such as being a member of a certain AWS organization. For more information about AWS Organizations, see What Is AWS Organizations in the AWS Organizations User Guide. If you specify Condition with an AWS organization ID, and specify "*" as the value for Principal, you grant permission to all the accounts in the named organization. The Condition is a JSON string which must contain Type, Key, and Value fields. Defaults to None.
        policy(str, optional): A JSON string that describes the permission policy statement. You can include a Policy parameter in the request instead of using the StatementId, Action, Principal, or Condition parameters. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.permission.put(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.permission.put
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="put_permission",
        op_kwargs={
            "EventBusName": event_bus_name,
            "Action": action,
            "Principal": principal,
            "StatementId": statement_id,
            "Condition": condition,
            "Policy": policy,
        },
    )


async def remove(
    hub,
    ctx,
    statement_id: str = None,
    remove_all_permissions: bool = None,
    event_bus_name: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Revokes the permission of another AWS account to be able to put events to the specified event bus. Specify the account to revoke by the StatementId value that you associated with the account when you granted it permission with PutPermission. You can find the StatementId by using DescribeEventBus.

    Args:
        statement_id(str, optional): The statement ID corresponding to the account that is no longer allowed to put events to the default event bus. Defaults to None.
        remove_all_permissions(bool, optional): Specifies whether to remove all permissions. Defaults to None.
        event_bus_name(str, optional): The name of the event bus to revoke permissions for. If you omit this, the default event bus is used. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.permission.remove(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.permission.remove
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="remove_permission",
        op_kwargs={
            "StatementId": statement_id,
            "RemoveAllPermissions": remove_all_permissions,
            "EventBusName": event_bus_name,
        },
    )
