"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, name: str, account: str) -> Dict:
    r"""
    **Autogenerated function**

    Called by an SaaS partner to create a partner event source. This operation is not used by AWS customers. Each partner event source can be used by one AWS account to create a matching partner event bus in that AWS account. A SaaS partner must create one partner event source for each AWS account that wants to receive those event types.  A partner event source creates events based on resources within the SaaS partner's service or application. An AWS account that creates a partner event bus that matches the partner event source can use that event bus to receive events from the partner, and then process them using AWS Events rules and targets. Partner event source names follow this format:   partner_name/event_namespace/event_name    partner_name is determined during partner registration and identifies the partner to AWS customers. event_namespace is determined by the partner and is a way for the partner to categorize their events. event_name is determined by the partner, and should uniquely identify an event-generating resource within the partner system. The combination of event_namespace and event_name should help AWS customers decide whether to create an event bus to receive these events.

    Args:
        name(str): The name of the partner event source. This name must be unique and must be in the format  partner_name/event_namespace/event_name . The AWS account that wants to use this partner event source must create a partner event bus with a name that matches the name of the partner event source.
        account(str): The AWS account ID that is permitted to create a matching partner event bus for this partner event source.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.partner_event.source.init.create(
                ctx, name=value, account=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.partner_event.source.init.create name=value, account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="create_partner_event_source",
        op_kwargs={"Name": name, "Account": account},
    )


async def delete(hub, ctx, name: str, account: str) -> None:
    r"""
    **Autogenerated function**

    This operation is used by SaaS partners to delete a partner event source. This operation is not used by AWS customers. When you delete an event source, the status of the corresponding partner event bus in the AWS customer account becomes DELETED.

    Args:
        name(str): The name of the event source to delete.
        account(str): The AWS account ID of the AWS customer that the event source was created for.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.partner_event.source.init.delete(
                ctx, name=value, account=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.partner_event.source.init.delete name=value, account=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="delete_partner_event_source",
        op_kwargs={"Name": name, "Account": account},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    An SaaS partner can use this operation to list details about a partner event source that they have created. AWS customers do not use this operation. Instead, AWS customers can use DescribeEventSource to see details about a partner event source that is shared with them.

    Args:
        name(str): The name of the event source to display.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.partner_event.source.init.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.partner_event.source.init.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_partner_event_source",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub, ctx, name_prefix: str, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by AWS customers.

    Args:
        name_prefix(str): If you specify this, the results are limited to only those partner event sources that start with the string you specify.
        next_token(str, optional): The token returned by a previous call to this operation. Specifying this retrieves the next set of results. Defaults to None.
        limit(int, optional): pecifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.partner_event.source.init.list_all(ctx, name_prefix=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.partner_event.source.init.list_all name_prefix=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_partner_event_sources",
        op_kwargs={"NamePrefix": name_prefix, "NextToken": next_token, "Limit": limit},
    )
