"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, event_source_name: str, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    An SaaS partner can use this operation to display the AWS account ID that a particular partner event source name is associated with. This operation is not used by AWS customers.

    Args:
        event_source_name(str): The name of the partner event source to display account information about.
        next_token(str, optional): The token returned by a previous call to this operation. Specifying this retrieves the next set of results. Defaults to None.
        limit(int, optional): Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.partner_event.source.account.list_all(
                ctx, event_source_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.partner_event.source.account.list_all event_source_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_partner_event_source_accounts",
        op_kwargs={
            "EventSourceName": event_source_name,
            "NextToken": next_token,
            "Limit": limit,
        },
    )
