"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(hub, ctx, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    This is used by SaaS partners to write events to a customer's partner event bus. AWS customers do not use this operation.

    Args:
        entries(List): The list of events to write to the event bus.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.partner_event.init.put_multiple(ctx, entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.partner_event.init.put_multiple entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="put_partner_events",
        op_kwargs={"Entries": entries},
    )
