"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def activate(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.

    Args:
        name(str): The name of the partner event source to activate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.source.activate(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.source.activate name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="activate_event_source",
        op_kwargs={"Name": name},
    )


async def deactivate(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted.  When you deactivate a partner event source, the source goes into PENDING state. If it remains in PENDING state for more than two weeks, it is deleted. To activate a deactivated partner event source, use ActivateEventSource.

    Args:
        name(str): The name of the partner event source to deactivate.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.source.deactivate(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.source.deactivate name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="deactivate_event_source",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation lists details about a partner event source that is shared with your account.

    Args:
        name(str): The name of the partner event source to display the details of.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.source.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.source.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_event_source",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub, ctx, name_prefix: str = None, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    You can use this to see all the partner event sources that have been shared with your AWS account. For more information about partner event sources, see CreateEventBus.

    Args:
        name_prefix(str, optional): Specifying this limits the results to only those partner event sources with names that start with the specified prefix. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.source.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.source.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_event_sources",
        op_kwargs={"NamePrefix": name_prefix, "NextToken": next_token, "Limit": limit},
    )
