"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(hub, ctx, event_pattern: str, event: str) -> Dict:
    r"""
    **Autogenerated function**

    Tests whether the specified event pattern matches the provided event. Most services in AWS treat : or / as the same character in Amazon Resource Names (ARNs). However, EventBridge uses an exact match in event patterns and rules. Be sure to use the correct ARN characters when creating event patterns so that they match the ARN syntax in the event you want to match.

    Args:
        event_pattern(str): The event pattern. For more information, see Events and Event Patterns in the Amazon EventBridge User Guide.
        event(str): The event, in JSON format, to test against the event pattern. The JSON must follow the format specified in AWS Events, and the following fields are mandatory:    id     account     source     time     region     resources     detail-type   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.pattern.test(ctx, event_pattern=value, event=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.pattern.test event_pattern=value, event=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="test_event_pattern",
        op_kwargs={"EventPattern": event_pattern, "Event": event},
    )
