"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def put_multiple(hub, ctx, entries: List) -> Dict:
    r"""
    **Autogenerated function**

    Sends custom events to Amazon EventBridge so that they can be matched to rules.

    Args:
        entries(List): The entry that defines an event in your system. You can specify several parameters for the entry such as the source and type of the event, resources associated with the event, and so on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.init.put_multiple(ctx, entries=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.init.put_multiple entries=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="put_events",
        op_kwargs={"Entries": entries},
    )
