"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, event_source_name: str = None, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.

    Args:
        name(str): The name of the new event bus.  Event bus names cannot contain the / character. You can't use the name default for a custom event bus, as this name is already used for your account's default event bus. If this is a partner event bus, the name must exactly match the name of the partner event source that this event bus is matched to.
        event_source_name(str, optional): If you are creating a partner event bus, this specifies the partner event source that the new event bus will be matched with. Defaults to None.
        tags(List, optional): Tags to associate with the event bus. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.bus.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.bus.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="create_event_bus",
        op_kwargs={"Name": name, "EventSourceName": event_source_name, "Tags": tags},
    )


async def delete(hub, ctx, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.

    Args:
        name(str): The name of the event bus to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.bus.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.bus.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="delete_event_bus",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Displays details about an event bus in your account. This can include the external AWS accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.  To enable your account to receive events from other accounts on its default event bus, use PutPermission. For more information about partner event buses, see CreateEventBus.

    Args:
        name(str, optional): The name or ARN of the event bus to show details for. If you omit this, the default event bus is displayed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.bus.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.bus.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_event_bus",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub, ctx, name_prefix: str = None, next_token: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.

    Args:
        name_prefix(str, optional): Specifying this limits the results to only those event buses with names that start with the specified prefix. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): Specifying this limits the number of results returned by this operation. The operation also returns a NextToken which you can use in a subsequent operation to retrieve the next set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.event.bus.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.event.bus.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_event_buses",
        op_kwargs={"NamePrefix": name_prefix, "NextToken": next_token, "Limit": limit},
    )
