"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    name: str,
    authorization_type: str,
    auth_parameters: Dict,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.

    Args:
        name(str): The name for the connection to create.
        description(str, optional): A description for the connection to create. Defaults to None.
        authorization_type(str): The type of authorization to use for the connection.
        auth_parameters(Dict): A CreateConnectionAuthRequestParameters object that contains the authorization parameters to use to authorize with the endpoint. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.connection.create(
                ctx, name=value, authorization_type=value, auth_parameters=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.connection.create name=value, authorization_type=value, auth_parameters=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="create_connection",
        op_kwargs={
            "Name": name,
            "Description": description,
            "AuthorizationType": authorization_type,
            "AuthParameters": auth_parameters,
        },
    )


async def deauthorize(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.

    Args:
        name(str): The name of the connection to remove authorization from.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.connection.deauthorize(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.connection.deauthorize name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="deauthorize_connection",
        op_kwargs={"Name": name},
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a connection.

    Args:
        name(str): The name of the connection to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.connection.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.connection.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="delete_connection",
        op_kwargs={"Name": name},
    )


async def describe(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details about a connection.

    Args:
        name(str): The name of the connection to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.connection.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.connection.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_connection",
        op_kwargs={"Name": name},
    )


async def list_all(
    hub,
    ctx,
    name_prefix: str = None,
    connection_state: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a list of connections from the account.

    Args:
        name_prefix(str, optional): A name prefix to filter results returned. Only connections with a name that starts with the prefix are returned. Defaults to None.
        connection_state(str, optional): The state of the connection. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): The maximum number of connections to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.connection.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.connection.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_connections",
        op_kwargs={
            "NamePrefix": name_prefix,
            "ConnectionState": connection_state,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def update(
    hub,
    ctx,
    name: str,
    description: str = None,
    authorization_type: str = None,
    auth_parameters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates settings for a connection.

    Args:
        name(str): The name of the connection to update.
        description(str, optional): A description for the connection. Defaults to None.
        authorization_type(str, optional): The type of authorization to use for the connection. Defaults to None.
        auth_parameters(Dict, optional): The authorization parameters to use for the connection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.connection.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.connection.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="update_connection",
        op_kwargs={
            "Name": name,
            "Description": description,
            "AuthorizationType": authorization_type,
            "AuthParameters": auth_parameters,
        },
    )
