"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    archive_name: str,
    event_source_arn: str,
    description: str = None,
    event_pattern: str = None,
    retention_days: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.

    Args:
        archive_name(str): The name for the archive to create.
        event_source_arn(str): The ARN of the event source associated with the archive.
        description(str, optional): A description for the archive. Defaults to None.
        event_pattern(str, optional): An event pattern to use to filter events sent to the archive. Defaults to None.
        retention_days(int, optional): The number of days to retain events for. Default value is 0. If set to 0, events are retained indefinitely. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.archive.create(
                ctx, archive_name=value, event_source_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.archive.create archive_name=value, event_source_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="create_archive",
        op_kwargs={
            "ArchiveName": archive_name,
            "EventSourceArn": event_source_arn,
            "Description": description,
            "EventPattern": event_pattern,
            "RetentionDays": retention_days,
        },
    )


async def delete(hub, ctx, archive_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified archive.

    Args:
        archive_name(str): The name of the archive to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.archive.delete(ctx, archive_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.archive.delete archive_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="delete_archive",
        op_kwargs={"ArchiveName": archive_name},
    )


async def describe(hub, ctx, archive_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves details about an archive.

    Args:
        archive_name(str): The name of the archive to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.archive.describe(ctx, archive_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.archive.describe archive_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="describe_archive",
        op_kwargs={"ArchiveName": archive_name},
    )


async def list_all(
    hub,
    ctx,
    name_prefix: str = None,
    event_source_arn: str = None,
    state: str = None,
    next_token: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.

    Args:
        name_prefix(str, optional): A name prefix to filter the archives returned. Only archives with name that match the prefix are returned. Defaults to None.
        event_source_arn(str, optional): The ARN of the event source associated with the archive. Defaults to None.
        state(str, optional): The state of the archive. Defaults to None.
        next_token(str, optional): The token returned by a previous call to retrieve the next set of results. Defaults to None.
        limit(int, optional): The maximum number of results to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.archive.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.archive.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="list_archives",
        op_kwargs={
            "NamePrefix": name_prefix,
            "EventSourceArn": event_source_arn,
            "State": state,
            "NextToken": next_token,
            "Limit": limit,
        },
    )


async def update(
    hub,
    ctx,
    archive_name: str,
    description: str = None,
    event_pattern: str = None,
    retention_days: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified archive.

    Args:
        archive_name(str): The name of the archive to update.
        description(str, optional): The description for the archive. Defaults to None.
        event_pattern(str, optional): The event pattern to use to filter events sent to the archive. Defaults to None.
        retention_days(int, optional): The number of days to retain events in the archive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.event.archive.update(ctx, archive_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.event.archive.update archive_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="events",
        operation="update_archive",
        op_kwargs={
            "ArchiveName": archive_name,
            "Description": description,
            "EventPattern": event_pattern,
            "RetentionDays": retention_days,
        },
    )
