"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.

    Args:
        domain_name(str): The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.upgrade.status.get(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.upgrade.status.get domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="get_upgrade_status",
        op_kwargs={"DomainName": domain_name},
    )
