"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def add(hub, ctx, arn: str, tag_list: List) -> None:
    r"""
    **Autogenerated function**

    Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See  Tagging Amazon Elasticsearch Service Domains for more information.

    Args:
        arn(str):  Specify the ARN for which you want to add the tags.
        tag_list(List):  List of Tag that need to be added for the Elasticsearch domain. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.tags.add(ctx, arn=value, tag_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.tags.add arn=value, tag_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="add_tags",
        op_kwargs={"ARN": arn, "TagList": tag_list},
    )


async def list_(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns all tags for the given Elasticsearch domain.

    Args:
        arn(str):  Specify the ARN for the Elasticsearch domain to which the tags are attached that you want to view.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.tags.list(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.tags.list arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="es", operation="list_tags", op_kwargs={"ARN": arn}
    )


async def remove(hub, ctx, arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes the specified set of tags from the specified Elasticsearch domain.

    Args:
        arn(str): Specifies the ARN for the Elasticsearch domain from which you want to delete the specified tags.
        tag_keys(List): Specifies the TagKey list which you want to remove from the Elasticsearch domain.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.tags.remove(ctx, arn=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.tags.remove arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="remove_tags",
        op_kwargs={"ARN": arn, "TagKeys": tag_keys},
    )
