"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    reserved_elasticsearch_instance_offering_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists available reserved Elasticsearch instance offerings.

    Args:
        reserved_elasticsearch_instance_offering_id(str, optional): The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier. Defaults to None.
        max_results(int, optional): Set this value to limit the number of results returned. If not specified, defaults to 100. Defaults to None.
        next_token(str, optional): NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.reserved_elasticsearch_instance.offering.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.reserved_elasticsearch_instance.offering.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_reserved_elasticsearch_instance_offerings",
        op_kwargs={
            "ReservedElasticsearchInstanceOfferingId": reserved_elasticsearch_instance_offering_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def purchase(
    hub,
    ctx,
    reserved_elasticsearch_instance_offering_id: str,
    reservation_name: str,
    instance_count: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Allows you to purchase reserved Elasticsearch instances.

    Args:
        reserved_elasticsearch_instance_offering_id(str): The ID of the reserved Elasticsearch instance offering to purchase.
        reservation_name(str): A customer-specified identifier to track this reservation.
        instance_count(int, optional): The number of Elasticsearch instances to reserve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.reserved_elasticsearch_instance.offering.purchase(
                ctx, reserved_elasticsearch_instance_offering_id=value, reservation_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.reserved_elasticsearch_instance.offering.purchase reserved_elasticsearch_instance_offering_id=value, reservation_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="purchase_reserved_elasticsearch_instance_offering",
        op_kwargs={
            "ReservedElasticsearchInstanceOfferingId": reserved_elasticsearch_instance_offering_id,
            "ReservationName": reservation_name,
            "InstanceCount": instance_count,
        },
    )
