"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    reserved_elasticsearch_instance_id: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about reserved Elasticsearch instances for this account.

    Args:
        reserved_elasticsearch_instance_id(str, optional): The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved Elasticsearch instance ID. Defaults to None.
        max_results(int, optional): Set this value to limit the number of results returned. If not specified, defaults to 100. Defaults to None.
        next_token(str, optional): NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.reserved_elasticsearch_instance.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.reserved_elasticsearch_instance.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_reserved_elasticsearch_instances",
        op_kwargs={
            "ReservedElasticsearchInstanceId": reserved_elasticsearch_instance_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
