"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, package_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of versions of the package, along with their creation time and commit message.

    Args:
        package_id(str): Returns an audit history of versions of the package.
        max_results(int, optional): Limits results to a maximum number of versions. Defaults to None.
        next_token(str, optional): Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.package.version_history.get(ctx, package_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.package.version_history.get package_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="get_package_version_history",
        op_kwargs={
            "PackageID": package_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
