"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    source_domain_info: Dict,
    destination_domain_info: Dict,
    connection_alias: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new cross-cluster search connection from a source domain to a destination domain.

    Args:
        source_domain_info(Dict): Specifies the DomainInformation for the source Elasticsearch domain.
        destination_domain_info(Dict): Specifies the DomainInformation for the destination Elasticsearch domain.
        connection_alias(str): Specifies the connection alias that will be used by the customer for this connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.outbound_cross_cluster_search_connection.create(
                ctx, source_domain_info=value, destination_domain_info=value, connection_alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.outbound_cross_cluster_search_connection.create source_domain_info=value, destination_domain_info=value, connection_alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="create_outbound_cross_cluster_search_connection",
        op_kwargs={
            "SourceDomainInfo": source_domain_info,
            "DestinationDomainInfo": destination_domain_info,
            "ConnectionAlias": connection_alias,
        },
    )


async def delete(hub, ctx, cross_cluster_search_connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows the source domain owner to delete an existing outbound cross-cluster search connection.

    Args:
        cross_cluster_search_connection_id(str): The id of the outbound connection that you want to permanently delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.outbound_cross_cluster_search_connection.delete(
                ctx, cross_cluster_search_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.outbound_cross_cluster_search_connection.delete cross_cluster_search_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="delete_outbound_cross_cluster_search_connection",
        op_kwargs={
            "CrossClusterSearchConnectionId": cross_cluster_search_connection_id
        },
    )


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the outbound cross-cluster search connections for a source domain.

    Args:
        filters(List, optional):  A list of filters used to match properties for outbound cross-cluster search connection. Available Filter names for this operation are:  cross-cluster-search-connection-id destination-domain-info.domain-name destination-domain-info.owner-id destination-domain-info.region source-domain-info.domain-name  . Defaults to None.
        max_results(int, optional): Set this value to limit the number of results returned. If not specified, defaults to 100. Defaults to None.
        next_token(str, optional):  NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.outbound_cross_cluster_search_connection.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.outbound_cross_cluster_search_connection.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_outbound_cross_cluster_search_connections",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
