"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def accept(hub, ctx, cross_cluster_search_connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows the destination domain owner to accept an inbound cross-cluster search connection request.

    Args:
        cross_cluster_search_connection_id(str): The id of the inbound connection that you want to accept.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.inbound_cross_cluster_search_connection.accept(
                ctx, cross_cluster_search_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.inbound_cross_cluster_search_connection.accept cross_cluster_search_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="accept_inbound_cross_cluster_search_connection",
        op_kwargs={
            "CrossClusterSearchConnectionId": cross_cluster_search_connection_id
        },
    )


async def delete(hub, ctx, cross_cluster_search_connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows the destination domain owner to delete an existing inbound cross-cluster search connection.

    Args:
        cross_cluster_search_connection_id(str): The id of the inbound connection that you want to permanently delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.inbound_cross_cluster_search_connection.delete(
                ctx, cross_cluster_search_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.inbound_cross_cluster_search_connection.delete cross_cluster_search_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="delete_inbound_cross_cluster_search_connection",
        op_kwargs={
            "CrossClusterSearchConnectionId": cross_cluster_search_connection_id
        },
    )


async def describe_all(
    hub, ctx, filters: List = None, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the inbound cross-cluster search connections for a destination domain.

    Args:
        filters(List, optional):  A list of filters used to match properties for inbound cross-cluster search connection. Available Filter names for this operation are:  cross-cluster-search-connection-id source-domain-info.domain-name source-domain-info.owner-id source-domain-info.region destination-domain-info.domain-name  . Defaults to None.
        max_results(int, optional): Set this value to limit the number of results returned. If not specified, defaults to 100. Defaults to None.
        next_token(str, optional):  NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.inbound_cross_cluster_search_connection.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.inbound_cross_cluster_search_connection.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_inbound_cross_cluster_search_connections",
        op_kwargs={
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def reject(hub, ctx, cross_cluster_search_connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows the destination domain owner to reject an inbound cross-cluster search connection request.

    Args:
        cross_cluster_search_connection_id(str): The id of the inbound connection that you want to reject.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.inbound_cross_cluster_search_connection.reject(
                ctx, cross_cluster_search_connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.inbound_cross_cluster_search_connection.reject cross_cluster_search_connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="reject_inbound_cross_cluster_search_connection",
        op_kwargs={
            "CrossClusterSearchConnectionId": cross_cluster_search_connection_id
        },
    )
