"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List all supported Elasticsearch versions

    Args:
        max_results(int, optional):  Set this value to limit the number of results returned. Value provided must be greater than 10 else it wont be honored. . Defaults to None.
        next_token(str, optional):  Paginated APIs accepts NextToken input to returns next page results and provides a NextToken output in the response which can be used by the client to retrieve more results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.version.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.version.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="list_elasticsearch_versions",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
