"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def cancel(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the AutomatedUpdateDate and when the UpdateStatus is in the PENDING_UPDATE state.

    Args:
        domain_name(str): The name of the domain that you want to stop the latest service software update on.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.service.software_update.cancel(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.service.software_update.cancel domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="cancel_elasticsearch_service_software_update",
        op_kwargs={"DomainName": domain_name},
    )


async def start(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Schedules a service software update for an Amazon ES domain.

    Args:
        domain_name(str): The name of the domain that you want to update to the latest service software.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.service.software_update.start(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.service.software_update.start domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="start_elasticsearch_service_software_update",
        op_kwargs={"DomainName": domain_name},
    )
