"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx) -> None:
    r"""
    **Autogenerated function**

    Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See Deleting Elasticsearch Service Role in VPC Endpoints for Amazon Elasticsearch Service Domains.

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.service.role.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.service.role.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="delete_elasticsearch_service_role",
        op_kwargs={},
    )
