"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, instance_type: str, elasticsearch_version: str, domain_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the  DomainName  to know what Limits are supported for modifying.

    Args:
        domain_name(str, optional):  DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for Elasticsearch  Limits  for existing domain. . Defaults to None.
        instance_type(str):  The instance type for an Elasticsearch cluster for which Elasticsearch  Limits  are needed. .
        elasticsearch_version(str):  Version of Elasticsearch for which  Limits  are needed. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.instance_type_.limit.describe_all(
                ctx, instance_type=value, elasticsearch_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.instance_type_.limit.describe_all instance_type=value, elasticsearch_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_elasticsearch_instance_type_limits",
        op_kwargs={
            "DomainName": domain_name,
            "InstanceType": instance_type,
            "ElasticsearchVersion": elasticsearch_version,
        },
    )
