"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__sub_alias__ = ["instance_type_", "instance_type"]


async def list_all(
    hub,
    ctx,
    elasticsearch_version: str,
    domain_name: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List all Elasticsearch instance types that are supported for given ElasticsearchVersion

    Args:
        elasticsearch_version(str): Version of Elasticsearch for which list of supported elasticsearch instance types are needed. .
        domain_name(str, optional): DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are querying for list of available Elasticsearch instance types when modifying existing domain. . Defaults to None.
        max_results(int, optional):  Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be honored. . Defaults to None.
        next_token(str, optional): NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for pagination. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.instance_type_.init.list_all(
                ctx, elasticsearch_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.instance_type_.init.list_all elasticsearch_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="list_elasticsearch_instance_types",
        op_kwargs={
            "ElasticsearchVersion": elasticsearch_version,
            "DomainName": domain_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
