"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.

    Args:
        domain_name(str): The Elasticsearch domain that you want to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.domain.config.describe(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.domain.config.describe domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_elasticsearch_domain_config",
        op_kwargs={"DomainName": domain_name},
    )


async def update(
    hub,
    ctx,
    domain_name: str,
    elasticsearch_cluster_config: Dict = None,
    ebs_options: Dict = None,
    snapshot_options: Dict = None,
    vpc_options: Dict = None,
    cognito_options: Dict = None,
    advanced_options: Dict = None,
    access_policies: str = None,
    log_publishing_options: Dict = None,
    domain_endpoint_options: Dict = None,
    advanced_security_options: Dict = None,
    node_to_node_encryption_options: Dict = None,
    encryption_at_rest_options: Dict = None,
    auto_tune_options: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.

    Args:
        domain_name(str): The name of the Elasticsearch domain that you are updating. .
        elasticsearch_cluster_config(Dict, optional): The type and number of instances to instantiate for the domain cluster. Defaults to None.
        ebs_options(Dict, optional): Specify the type and size of the EBS volume that you want to use. . Defaults to None.
        snapshot_options(Dict, optional): Option to set the time, in UTC format, for the daily automated snapshot. Default value is 0 hours. . Defaults to None.
        vpc_options(Dict, optional): Options to specify the subnets and security groups for VPC endpoint. For more information, see Creating a VPC in VPC Endpoints for Amazon Elasticsearch Service Domains. Defaults to None.
        cognito_options(Dict, optional): Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see Amazon Cognito Authentication for Kibana. Defaults to None.
        advanced_options(Dict, optional): Modifies the advanced option to allow references to indices in an HTTP request body. Must be false when configuring access to individual sub-resources. By default, the value is true. See Configuration Advanced Options for more information. Defaults to None.
        access_policies(str, optional): IAM access policy as a JSON-formatted string. Defaults to None.
        log_publishing_options(Dict, optional): Map of LogType and LogPublishingOption, each containing options to publish a given type of Elasticsearch log. Defaults to None.
        domain_endpoint_options(Dict, optional): Options to specify configuration that will be applied to the domain endpoint. Defaults to None.
        advanced_security_options(Dict, optional): Specifies advanced security options. Defaults to None.
        node_to_node_encryption_options(Dict, optional): Specifies the NodeToNodeEncryptionOptions. Defaults to None.
        encryption_at_rest_options(Dict, optional): Specifies the Encryption At Rest Options. Defaults to None.
        auto_tune_options(Dict, optional): Specifies Auto-Tune options. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.elasticsearch.domain.config.update(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.elasticsearch.domain.config.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="update_elasticsearch_domain_config",
        op_kwargs={
            "DomainName": domain_name,
            "ElasticsearchClusterConfig": elasticsearch_cluster_config,
            "EBSOptions": ebs_options,
            "SnapshotOptions": snapshot_options,
            "VPCOptions": vpc_options,
            "CognitoOptions": cognito_options,
            "AdvancedOptions": advanced_options,
            "AccessPolicies": access_policies,
            "LogPublishingOptions": log_publishing_options,
            "DomainEndpointOptions": domain_endpoint_options,
            "AdvancedSecurityOptions": advanced_security_options,
            "NodeToNodeEncryptionOptions": node_to_node_encryption_options,
            "EncryptionAtRestOptions": encryption_at_rest_options,
            "AutoTuneOptions": auto_tune_options,
        },
    )
