"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, package_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all Amazon ES domains associated with the package.

    Args:
        package_id(str): The package for which to list domains.
        max_results(int, optional): Limits results to a maximum number of domains. Defaults to None.
        next_token(str, optional): Used for pagination. Only necessary if a previous API call includes a non-null NextToken value. If provided, returns results for the next page. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.domain.for_package.list(ctx, package_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.domain.for_package.list package_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="list_domains_for_package",
        op_kwargs={
            "PackageID": package_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
