"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, domain_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.

    Args:
        domain_name(str): Specifies the domain name for which you want Auto-Tune action details.
        max_results(int, optional): Set this value to limit the number of results returned. If not specified, defaults to 100. Defaults to None.
        next_token(str, optional): NextToken is sent in case the earlier API call results contain the NextToken. It is used for pagination. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.domain.auto_tune.describe_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.domain.auto_tune.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="describe_domain_auto_tunes",
        op_kwargs={
            "DomainName": domain_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
