"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, domain_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a  DomainName  to get all upgrade compatible Elasticsearch versions for that specific domain.

    Args:
        domain_name(str, optional): The name of an Elasticsearch domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen). Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.es.compatible_elasticsearch_version.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.es.compatible_elasticsearch_version.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="es",
        operation="get_compatible_elasticsearch_versions",
        op_kwargs={"DomainName": domain_name},
    )
