"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, container_provider: Dict, client_token: str, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.

    Args:
        name(str): The specified name of the virtual cluster.
        container_provider(Dict): The container provider of the virtual cluster.
        client_token(str): The client token of the virtual cluster.
        tags(Dict, optional): The tags assigned to the virtual cluster. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.virtual_cluster.create(
                ctx, name=value, container_provider=value, client_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.virtual_cluster.create name=value, container_provider=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="create_virtual_cluster",
        op_kwargs={
            "name": name,
            "containerProvider": container_provider,
            "clientToken": client_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.

    Args:
        id_(str): The ID of the virtual cluster that will be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.virtual_cluster.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.virtual_cluster.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="delete_virtual_cluster",
        op_kwargs={"id": id_},
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.

    Args:
        id_(str): The ID of the virtual cluster that will be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.virtual_cluster.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.virtual_cluster.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="describe_virtual_cluster",
        op_kwargs={"id": id_},
    )


async def list_all(
    hub,
    ctx,
    container_provider_id: str = None,
    container_provider_type: str = None,
    created_after: str = None,
    created_before: str = None,
    states: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.

    Args:
        container_provider_id(str, optional): The container provider ID of the virtual cluster. Defaults to None.
        container_provider_type(str, optional): The container provider type of the virtual cluster. EKS is the only supported type as of now. Defaults to None.
        created_after(str, optional): The date and time after which the virtual clusters are created. Defaults to None.
        created_before(str, optional): The date and time before which the virtual clusters are created. Defaults to None.
        states(List, optional): The states of the requested virtual clusters. Defaults to None.
        max_results(int, optional): The maximum number of virtual clusters that can be listed. Defaults to None.
        next_token(str, optional): The token for the next set of virtual clusters to return. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.virtual_cluster.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.virtual_cluster.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="list_virtual_clusters",
        op_kwargs={
            "containerProviderId": container_provider_id,
            "containerProviderType": container_provider_type,
            "createdAfter": created_after,
            "createdBefore": created_before,
            "states": states,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
