"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    virtual_cluster_id: str,
    type_: str,
    release_label: str,
    execution_role_arn: str,
    certificate_arn: str,
    client_token: str,
    configuration_overrides: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.

    Args:
        name(str): The name of the managed endpoint.
        virtual_cluster_id(str): The ID of the virtual cluster for which a managed endpoint is created.
        type_(str): The type of the managed endpoint.
        release_label(str): The Amazon EMR release version.
        execution_role_arn(str): The ARN of the execution role.
        certificate_arn(str): The certificate ARN of the managed endpoint.
        configuration_overrides(Dict, optional): The configuration settings that will be used to override existing configurations. Defaults to None.
        client_token(str): The client idempotency token for this create call.
        tags(Dict, optional): The tags of the managed endpoint. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.managed_endpoint.create(
                ctx,
                name=value,
                virtual_cluster_id=value,
                type_=value,
                release_label=value,
                execution_role_arn=value,
                certificate_arn=value,
                client_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.managed_endpoint.create name=value, virtual_cluster_id=value, type_=value, release_label=value, execution_role_arn=value, certificate_arn=value, client_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="create_managed_endpoint",
        op_kwargs={
            "name": name,
            "virtualClusterId": virtual_cluster_id,
            "type": type_,
            "releaseLabel": release_label,
            "executionRoleArn": execution_role_arn,
            "certificateArn": certificate_arn,
            "configurationOverrides": configuration_overrides,
            "clientToken": client_token,
            "tags": tags,
        },
    )


async def delete(hub, ctx, id_: str, virtual_cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.

    Args:
        id_(str): The ID of the managed endpoint.
        virtual_cluster_id(str): The ID of the endpoint's virtual cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.managed_endpoint.delete(
                ctx, id_=value, virtual_cluster_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.managed_endpoint.delete id_=value, virtual_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="delete_managed_endpoint",
        op_kwargs={"id": id_, "virtualClusterId": virtual_cluster_id},
    )


async def describe(hub, ctx, id_: str, virtual_cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.

    Args:
        id_(str): This output displays ID of the managed endpoint.
        virtual_cluster_id(str): The ID of the endpoint's virtual cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.managed_endpoint.describe(
                ctx, id_=value, virtual_cluster_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.managed_endpoint.describe id_=value, virtual_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="describe_managed_endpoint",
        op_kwargs={"id": id_, "virtualClusterId": virtual_cluster_id},
    )


async def list_all(
    hub,
    ctx,
    virtual_cluster_id: str,
    created_before: str = None,
    created_after: str = None,
    types: List = None,
    states: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects EMR Studio to Amazon EMR on EKS so that EMR Studio can communicate with your virtual cluster.

    Args:
        virtual_cluster_id(str): The ID of the virtual cluster.
        created_before(str, optional): The date and time before which the endpoints are created. Defaults to None.
        created_after(str, optional):  The date and time after which the endpoints are created. Defaults to None.
        types(List, optional): The types of the managed endpoints. Defaults to None.
        states(List, optional): The states of the managed endpoints. Defaults to None.
        max_results(int, optional): The maximum number of managed endpoints that can be listed. Defaults to None.
        next_token(str, optional):  The token for the next set of managed endpoints to return. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.managed_endpoint.list_all(
                ctx, virtual_cluster_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.managed_endpoint.list_all virtual_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="list_managed_endpoints",
        op_kwargs={
            "virtualClusterId": virtual_cluster_id,
            "createdBefore": created_before,
            "createdAfter": created_after,
            "types": types,
            "states": states,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
