"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(hub, ctx, id_: str, virtual_cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

    Args:
        id_(str): The ID of the job run to cancel.
        virtual_cluster_id(str): The ID of the virtual cluster for which the job run will be canceled.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.job_run.cancel(
                ctx, id_=value, virtual_cluster_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.job_run.cancel id_=value, virtual_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="cancel_job_run",
        op_kwargs={"id": id_, "virtualClusterId": virtual_cluster_id},
    )


async def describe(hub, ctx, id_: str, virtual_cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

    Args:
        id_(str): The ID of the job run request. .
        virtual_cluster_id(str): The ID of the virtual cluster for which the job run is submitted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.job_run.describe(
                ctx, id_=value, virtual_cluster_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.job_run.describe id_=value, virtual_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="describe_job_run",
        op_kwargs={"id": id_, "virtualClusterId": virtual_cluster_id},
    )


async def list_all(
    hub,
    ctx,
    virtual_cluster_id: str,
    created_before: str = None,
    created_after: str = None,
    name: str = None,
    states: List = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

    Args:
        virtual_cluster_id(str): The ID of the virtual cluster for which to list the job run. .
        created_before(str, optional): The date and time before which the job runs were submitted. Defaults to None.
        created_after(str, optional): The date and time after which the job runs were submitted. Defaults to None.
        name(str, optional): The name of the job run. Defaults to None.
        states(List, optional): The states of the job run. Defaults to None.
        max_results(int, optional): The maximum number of job runs that can be listed. Defaults to None.
        next_token(str, optional): The token for the next set of job runs to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.job_run.list_all(ctx, virtual_cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.job_run.list_all virtual_cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="list_job_runs",
        op_kwargs={
            "virtualClusterId": virtual_cluster_id,
            "createdBefore": created_before,
            "createdAfter": created_after,
            "name": name,
            "states": states,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def start(
    hub,
    ctx,
    virtual_cluster_id: str,
    client_token: str,
    execution_role_arn: str,
    release_label: str,
    job_driver: Dict,
    name: str = None,
    configuration_overrides: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.

    Args:
        name(str, optional): The name of the job run. Defaults to None.
        virtual_cluster_id(str): The virtual cluster ID for which the job run request is submitted.
        client_token(str): The client idempotency token of the job run request. .
        execution_role_arn(str): The execution role ARN for the job run.
        release_label(str): The Amazon EMR release version to use for the job run.
        job_driver(Dict): The job driver for the job run.
        configuration_overrides(Dict, optional): The configuration overrides for the job run. Defaults to None.
        tags(Dict, optional): The tags assigned to job runs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr_container.job_run.start(
                ctx,
                virtual_cluster_id=value,
                client_token=value,
                execution_role_arn=value,
                release_label=value,
                job_driver=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr_container.job_run.start virtual_cluster_id=value, client_token=value, execution_role_arn=value, release_label=value, job_driver=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr-containers",
        operation="start_job_run",
        op_kwargs={
            "name": name,
            "virtualClusterId": virtual_cluster_id,
            "clientToken": client_token,
            "executionRoleArn": execution_role_arn,
            "releaseLabel": release_label,
            "jobDriver": job_driver,
            "configurationOverrides": configuration_overrides,
            "tags": tags,
        },
    )
