"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


__func_alias__ = {"set_": "set"}


async def set_(hub, ctx, job_flow_ids: List, termination_protected: bool) -> None:
    r"""
    **Autogenerated function**

    SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster cannot be terminated by user intervention, an API call, or in the event of a job-flow error. The cluster still terminates upon successful completion of the job flow. Calling SetTerminationProtection on a cluster is similar to calling the Amazon EC2 DisableAPITermination API on all EC2 instances in a cluster.  SetTerminationProtection is used to prevent accidental termination of a cluster and to ensure that in the event of an error, the instances persist so that you can recover any data stored in their ephemeral instance storage.  To terminate a cluster that has been locked by setting SetTerminationProtection to true, you must first unlock the job flow by a subsequent call to SetTerminationProtection in which you set the value to false.   For more information, seeManaging Cluster Termination in the Amazon EMR Management Guide.

    Args:
        job_flow_ids(List):  A list of strings that uniquely identify the clusters to protect. This identifier is returned by RunJobFlow and can also be obtained from DescribeJobFlows . .
        termination_protected(bool): A Boolean that indicates whether to protect the cluster and prevent the Amazon EC2 instances in the cluster from shutting down due to API calls, user intervention, or job-flow error.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.termination_protection.set(
                ctx, job_flow_ids=value, termination_protected=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.termination_protection.set job_flow_ids=value, termination_protected=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="set_termination_protection",
        op_kwargs={
            "JobFlowIds": job_flow_ids,
            "TerminationProtected": termination_protected,
        },
    )
