"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, resource_id: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds tags to an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see Tag Clusters.

    Args:
        resource_id(str): The Amazon EMR resource identifier to which tags will be added. This value must be a cluster identifier.
        tags(List): A list of tags to associate with a cluster and propagate to EC2 instances. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.tags.add(ctx, resource_id=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.tags.add resource_id=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="add_tags",
        op_kwargs={"ResourceId": resource_id, "Tags": tags},
    )


async def remove(hub, ctx, resource_id: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from an Amazon EMR resource. Tags make it easier to associate clusters in various ways, such as grouping clusters to track your Amazon EMR resource allocation costs. For more information, see Tag Clusters.  The following example removes the stack tag with value Prod from a cluster:

    Args:
        resource_id(str): The Amazon EMR resource identifier from which tags will be removed. This value must be a cluster identifier.
        tag_keys(List): A list of tag keys to remove from a resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.tags.remove(ctx, resource_id=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.tags.remove resource_id=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="remove_tags",
        op_kwargs={"ResourceId": resource_id, "TagKeys": tag_keys},
    )
