"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    studio_id: str,
    identity_type: str,
    session_policy_arn: str,
    identity_id: str = None,
    identity_name: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Maps a user or group to the Amazon EMR Studio specified by StudioId, and applies a session policy to refine Studio permissions for that user or group.

    Args:
        studio_id(str): The ID of the Amazon EMR Studio to which the user or group will be mapped.
        identity_id(str, optional): The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store. For more information, see UserId and GroupId in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_name(str, optional): The name of the user or group. For more information, see UserName and DisplayName in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_type(str): Specifies whether the identity to map to the Amazon EMR Studio is a user or a group.
        session_policy_arn(str): The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role. For more information, see Create an EMR Studio User Role with Session Policies.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.session_mapping.create(
                ctx, studio_id=value, identity_type=value, session_policy_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.session_mapping.create studio_id=value, identity_type=value, session_policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="create_studio_session_mapping",
        op_kwargs={
            "StudioId": studio_id,
            "IdentityId": identity_id,
            "IdentityName": identity_name,
            "IdentityType": identity_type,
            "SessionPolicyArn": session_policy_arn,
        },
    )


async def delete(
    hub,
    ctx,
    studio_id: str,
    identity_type: str,
    identity_id: str = None,
    identity_name: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Removes a user or group from an Amazon EMR Studio.

    Args:
        studio_id(str): The ID of the Amazon EMR Studio.
        identity_id(str, optional): The globally unique identifier (GUID) of the user or group to remove from the Amazon EMR Studio. For more information, see UserId and GroupId in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_name(str, optional): The name of the user name or group to remove from the Amazon EMR Studio. For more information, see UserName and DisplayName in the Amazon Web Services SSO Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_type(str): Specifies whether the identity to delete from the Amazon EMR Studio is a user or a group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.session_mapping.delete(
                ctx, studio_id=value, identity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.session_mapping.delete studio_id=value, identity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="delete_studio_session_mapping",
        op_kwargs={
            "StudioId": studio_id,
            "IdentityId": identity_id,
            "IdentityName": identity_name,
            "IdentityType": identity_type,
        },
    )


async def get(
    hub,
    ctx,
    studio_id: str,
    identity_type: str,
    identity_id: str = None,
    identity_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Fetches mapping details for the specified Amazon EMR Studio and identity (user or group).

    Args:
        studio_id(str): The ID of the Amazon EMR Studio.
        identity_id(str, optional): The globally unique identifier (GUID) of the user or group. For more information, see UserId and GroupId in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_name(str, optional): The name of the user or group to fetch. For more information, see UserName and DisplayName in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_type(str): Specifies whether the identity to fetch is a user or a group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.session_mapping.get(
                ctx, studio_id=value, identity_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.session_mapping.get studio_id=value, identity_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="get_studio_session_mapping",
        op_kwargs={
            "StudioId": studio_id,
            "IdentityId": identity_id,
            "IdentityName": identity_name,
            "IdentityType": identity_type,
        },
    )


async def list_all(
    hub, ctx, studio_id: str = None, identity_type: str = None, marker: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all user or group session mappings for the Amazon EMR Studio specified by StudioId.

    Args:
        studio_id(str, optional): The ID of the Amazon EMR Studio. Defaults to None.
        identity_type(str, optional): Specifies whether to return session mappings for users or groups. If not specified, the results include session mapping details for both users and groups. Defaults to None.
        marker(str, optional): The pagination token that indicates the set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.session_mapping.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.session_mapping.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_studio_session_mappings",
        op_kwargs={
            "StudioId": studio_id,
            "IdentityType": identity_type,
            "Marker": marker,
        },
    )


async def update(
    hub,
    ctx,
    studio_id: str,
    identity_type: str,
    session_policy_arn: str,
    identity_id: str = None,
    identity_name: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates the session policy attached to the user or group for the specified Amazon EMR Studio.

    Args:
        studio_id(str): The ID of the Amazon EMR Studio.
        identity_id(str, optional): The globally unique identifier (GUID) of the user or group. For more information, see UserId and GroupId in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_name(str, optional): The name of the user or group to update. For more information, see UserName and DisplayName in the Amazon Web Services SSO Identity Store API Reference. Either IdentityName or IdentityId must be specified. Defaults to None.
        identity_type(str): Specifies whether the identity to update is a user or a group.
        session_policy_arn(str): The Amazon Resource Name (ARN) of the session policy to associate with the specified user or group.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.session_mapping.update(
                ctx, studio_id=value, identity_type=value, session_policy_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.session_mapping.update studio_id=value, identity_type=value, session_policy_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="update_studio_session_mapping",
        op_kwargs={
            "StudioId": studio_id,
            "IdentityId": identity_id,
            "IdentityName": identity_name,
            "IdentityType": identity_type,
            "SessionPolicyArn": session_policy_arn,
        },
    )
