"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    auth_mode: str,
    vpc_id: str,
    subnet_ids: List,
    service_role: str,
    user_role: str,
    workspace_security_group_id: str,
    engine_security_group_id: str,
    default_s3_location: str,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Amazon EMR Studio.

    Args:
        name(str): A descriptive name for the Amazon EMR Studio.
        description(str, optional): A detailed description of the Amazon EMR Studio. Defaults to None.
        auth_mode(str): Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM. Amazon EMR Studio currently only supports SSO authentication.
        vpc_id(str): The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
        subnet_ids(List): A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by VpcId. Studio users can create a Workspace in any of the specified subnets.
        service_role(str): The IAM role that will be assumed by the Amazon EMR Studio. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
        user_role(str): The IAM user role that will be assumed by users and groups logged in to an Amazon EMR Studio. The permissions attached to this IAM role can be scoped down for each user or group using session policies.
        workspace_security_group_id(str): The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by VpcId.
        engine_security_group_id(str): The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by VpcId.
        default_s3_location(str): The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
        tags(List, optional): A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that consist of a required key string with a maximum of 128 characters, and an optional value string with a maximum of 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.init.create(
                ctx,
                name=value,
                auth_mode=value,
                vpc_id=value,
                subnet_ids=value,
                service_role=value,
                user_role=value,
                workspace_security_group_id=value,
                engine_security_group_id=value,
                default_s3_location=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.init.create name=value, auth_mode=value, vpc_id=value, subnet_ids=value, service_role=value, user_role=value, workspace_security_group_id=value, engine_security_group_id=value, default_s3_location=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="create_studio",
        op_kwargs={
            "Name": name,
            "Description": description,
            "AuthMode": auth_mode,
            "VpcId": vpc_id,
            "SubnetIds": subnet_ids,
            "ServiceRole": service_role,
            "UserRole": user_role,
            "WorkspaceSecurityGroupId": workspace_security_group_id,
            "EngineSecurityGroupId": engine_security_group_id,
            "DefaultS3Location": default_s3_location,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, studio_id: str) -> None:
    r"""
    **Autogenerated function**

    Removes an Amazon EMR Studio from the Studio metadata store.

    Args:
        studio_id(str): The ID of the Amazon EMR Studio.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.init.delete(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.init.delete studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="delete_studio",
        op_kwargs={"StudioId": studio_id},
    )


async def describe(hub, ctx, studio_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio access URL, and so on.

    Args:
        studio_id(str): The Amazon EMR Studio ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.init.describe(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.init.describe studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="describe_studio",
        op_kwargs={"StudioId": studio_id},
    )


async def list_all(hub, ctx, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all Amazon EMR Studios associated with the account. The list includes details such as ID, Studio Access URL, and creation time for each Studio.

    Args:
        marker(str, optional): The pagination token that indicates the set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="emr", operation="list_studios", op_kwargs={"Marker": marker}
    )


async def update(
    hub,
    ctx,
    studio_id: str,
    name: str = None,
    description: str = None,
    subnet_ids: List = None,
    default_s3_location: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.

    Args:
        studio_id(str): The ID of the Amazon EMR Studio to update.
        name(str, optional): A descriptive name for the Amazon EMR Studio. Defaults to None.
        description(str, optional): A detailed description to assign to the Amazon EMR Studio. Defaults to None.
        subnet_ids(List, optional): A list of subnet IDs to associate with the Amazon EMR Studio. The list can include new subnet IDs, but must also include all of the subnet IDs previously associated with the Studio. The list order does not matter. A Studio can have a maximum of 5 subnets. The subnets must belong to the same VPC as the Studio. . Defaults to None.
        default_s3_location(str, optional): The Amazon S3 location to back up Workspaces and notebook files for the Amazon EMR Studio. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.studio.init.update(ctx, studio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.studio.init.update studio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="update_studio",
        op_kwargs={
            "StudioId": studio_id,
            "Name": name,
            "Description": description,
            "SubnetIds": subnet_ids,
            "DefaultS3Location": default_s3_location,
        },
    )
