"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def cancel(
    hub, ctx, cluster_id: str, step_ids: List, step_cancellation_option: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Cancels a pending step or steps in a running cluster. Available only in Amazon EMR versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a PENDING or RUNNING state. In earlier versions of Amazon EMR, you can only cancel steps that are in a PENDING state.

    Args:
        cluster_id(str): The ClusterID for the specified steps that will be canceled. Use RunJobFlow and ListClusters to get ClusterIDs. .
        step_ids(List): The list of StepIDs to cancel. Use ListSteps to get steps and their states for the specified cluster.
        step_cancellation_option(str, optional): The option to choose to cancel RUNNING steps. By default, the value is SEND_INTERRUPT. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.step.cancel(ctx, cluster_id=value, step_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.step.cancel cluster_id=value, step_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="cancel_steps",
        op_kwargs={
            "ClusterId": cluster_id,
            "StepIds": step_ids,
            "StepCancellationOption": step_cancellation_option,
        },
    )


async def describe(hub, ctx, cluster_id: str, step_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Provides more detail about the cluster step.

    Args:
        cluster_id(str): The identifier of the cluster with steps to describe.
        step_id(str): The identifier of the step to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.step.describe(ctx, cluster_id=value, step_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.step.describe cluster_id=value, step_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="describe_step",
        op_kwargs={"ClusterId": cluster_id, "StepId": step_id},
    )


async def list_all(
    hub,
    ctx,
    cluster_id: str,
    step_states: List = None,
    step_ids: List = None,
    marker: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides a list of steps for the cluster in reverse order unless you specify stepIds with the request or filter by StepStates. You can specify a maximum of 10 stepIDs. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a Marker, which is a pagination token that indicates the next set of steps to retrieve.

    Args:
        cluster_id(str): The identifier of the cluster for which to list the steps.
        step_states(List, optional): The filter to limit the step list based on certain states. Defaults to None.
        step_ids(List, optional): The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step IDs. The character constraint applies to the overall length of the array. Defaults to None.
        marker(str, optional): The maximum number of steps that a single ListSteps action returns is 50. To return a longer list of steps, use multiple ListSteps actions along with the Marker parameter, which is a pagination token that indicates the next set of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.emr.step.list_all(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.emr.step.list_all cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="emr",
        operation="list_steps",
        op_kwargs={
            "ClusterId": cluster_id,
            "StepStates": step_states,
            "StepIds": step_ids,
            "Marker": marker,
        },
    )
